<?php
/**
 * Admin interface class
 */

if (!defined('ABSPATH')) {
    exit;
}

class WP_SSL_Admin {
    
    public function add_admin_menu() {
        add_menu_page(
            __('SSL Certificate Manager', 'wp-ssl-manager'),
            __('SSL Manager', 'wp-ssl-manager'),
            'manage_options',
            'wp-ssl-manager',
            array($this, 'render_dashboard_page'),
            'dashicons-lock',
            30
        );
        
        add_submenu_page(
            'wp-ssl-manager',
            __('Settings', 'wp-ssl-manager'),
            __('Settings', 'wp-ssl-manager'),
            'manage_options',
            'wp-ssl-manager-settings',
            array($this, 'render_settings_page')
        );
    }
    
    public function register_settings() {
        // API Settings
        register_setting('wp_ssl_manager_settings', 'wp_ssl_api_url');
        register_setting('wp_ssl_manager_settings', 'wp_ssl_client_id');
        register_setting('wp_ssl_manager_settings', 'wp_ssl_client_secret');
        
        // cPanel Settings
        register_setting('wp_ssl_manager_settings', 'wp_ssl_cpanel_host');
        register_setting('wp_ssl_manager_settings', 'wp_ssl_cpanel_user');
        register_setting('wp_ssl_manager_settings', 'wp_ssl_cpanel_pass');
        register_setting('wp_ssl_manager_settings', 'wp_ssl_cpanel_port');
    }
    
    public function render_dashboard_page() {
        include WP_SSL_MANAGER_PLUGIN_DIR . 'templates/dashboard.php';
    }
    
    public function render_settings_page() {
        include WP_SSL_MANAGER_PLUGIN_DIR . 'templates/settings.php';
    }
}

